/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.fw.mediasvc;

import com.ibm.hwmca.fw.log.FrameworkLog;
import com.ibm.hwmca.fw.mediasvc.MediaDevice;
import com.ibm.hwmca.fw.mediasvc.MediaDeviceException;
import com.ibm.hwmca.fw.mediasvc.MediaDeviceIdentifier;
import com.ibm.hwmca.fw.mediasvc.MediaDeviceLockException;
import com.ibm.hwmca.fw.mediasvc.MediaServicesErrorIds;
import com.ibm.hwmca.fw.mediasvc.NoMediaPresentException;
import com.ibm.hwmca.fw.util.RootProcess;
import com.ibm.hwmca.fw.util.Trace;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.util.StringTokenizer;

public class CdDvd
extends MediaDevice {
    private static final String CD_DVD_TEMP_FILE = "cdvd.media";

    CdDvd(MediaDeviceIdentifier id) throws MediaDeviceException {
        super(id);
        Trace.trace("XMDADEVT", "-> CdDvd.CdDvd(MediaDeviceIdentifier = " + id + ")");
        this.mountWithUid = true;
        Trace.trace("XMDADEVT", "<- CdDvd.CdDvd()");
    }

    boolean isMediaPresent() throws MediaDeviceLockException {
        Trace.trace("XMDADEVT", "-> CdDvd.isMediaPresent()");
        if (!this.isLockValid()) {
            throw new MediaDeviceLockException("Operation attempted by task other than device lock owner", this.mediaDeviceIdentifier.getCurrentLockOwner());
        }
        int rc = -1;
        try {
            String[] isMediaPresentCmd = new String[]{this.mediaServicesParameters.getParm("media.device.check.media.script"), this.mediaDeviceProperties.getDeviceFile(), this.mediaServicesParameters.getParm("media.temp.dir") + CD_DVD_TEMP_FILE, new Integer(2).toString(), this.mediaServicesParameters.getParm("media.log.dir") + this.mediaServicesParameters.getParm("media.log")};
            Trace.trace("XMDADEVF", "CdDvd.isMediaPresent(): isMediaPresentCmd[0] = " + isMediaPresentCmd[0]);
            Trace.trace("XMDADEVF", "CdDvd.isMediaPresent(): isMediaPresentCmd[1] = " + isMediaPresentCmd[1]);
            Trace.trace("XMDADEVF", "CdDvd.isMediaPresent(): isMediaPresentCmd[2] = " + isMediaPresentCmd[2]);
            Trace.trace("XMDADEVF", "CdDvd.isMediaPresent(): isMediaPresentCmd[3] = " + isMediaPresentCmd[3]);
            Trace.trace("XMDADEVF", "CdDvd.isMediaPresent(): isMediaPresentCmd[4] = " + isMediaPresentCmd[4]);
            rc = RootProcess.executeProgram(isMediaPresentCmd);
            Trace.trace("XMDADEVF", "CdDvd.isMediaPresent(): rc = " + rc);
        }
        catch (Exception exc) {
            Trace.trace("XMDADEVF", exc);
            MediaDeviceException mdexc = new MediaDeviceException(exc);
            new FrameworkLog(MediaServicesErrorIds._logInfo, 625, mdexc).log();
        }
        Trace.trace("XMDADEVT", "<- CdDvd.isMediaPresent()");
        return rc == 0;
    }

    public void eject() throws MediaDeviceException {
        Trace.trace("XMDADEVT", "-> CdDvd.eject()");
        if (!this.isLockValid()) {
            throw new MediaDeviceLockException("Operation attempted by task other than device lock owner", this.mediaDeviceIdentifier.getCurrentLockOwner());
        }
        try {
            String[] ejectCmd = new String[]{this.mediaServicesParameters.getParm("media.eject.script"), this.mediaDeviceProperties.getDeviceFile(), this.mediaServicesParameters.getParm("media.log.dir") + this.mediaServicesParameters.getParm("media.log")};
            Trace.trace("XMDADEVF", "CdDvd.eject(): ejectCmd[0] = " + ejectCmd[0]);
            Trace.trace("XMDADEVF", "CdDvd.eject(): ejectCmd[1] = " + ejectCmd[1]);
            Trace.trace("XMDADEVF", "CdDvd.eject(): ejectCmd[2] = " + ejectCmd[2]);
            int rc = RootProcess.executeProgram(ejectCmd);
            Trace.trace("XMDADEVF", "CdDvd.eject(): rc = " + rc);
            if (rc != 0) {
                throw new IOException("failure to eject media");
            }
        }
        catch (Exception exc) {
            Trace.trace("XMDADEVF", exc);
            MediaDeviceException mdexc = new MediaDeviceException(exc);
            new FrameworkLog(MediaServicesErrorIds._logInfo, 626, mdexc).log();
            throw mdexc;
        }
        Trace.trace("XMDADEVT", "<- CdDvd.eject()");
    }

    public String getLabel() throws MediaDeviceException, MediaDeviceLockException, NoMediaPresentException {
        Trace.trace("XMDADEVT", "-> CdDvd.getLabel()");
        if (!this.isLockValid()) {
            throw new MediaDeviceLockException("Operation attempted by task other than device lock owner", this.mediaDeviceIdentifier.getCurrentLockOwner());
        }
        if (!this.isMediaPresent()) {
            throw new NoMediaPresentException("missing media");
        }
        Trace.trace("XMDADEVT", "<- CdDvd.getLabel()");
        return this.mediaProperties.getLabel(this);
    }

    String readLabelFile(String labelFile) throws IOException {
        Trace.trace("XMDADEVT", "-> CdDvd.readLabelFile(labelFile = " + labelFile + ")");
        String buffer = null;
        String label = null;
        FileReader tfr = new FileReader(labelFile);
        BufferedReader tbr = new BufferedReader(tfr);
        buffer = tbr.readLine();
        if (buffer != null) {
            if (buffer.indexOf("32+0") != -1) {
                Trace.trace("XMDADEVF", "CdDvd.readLabelFile(): The label file was created with the dd command");
                StringTokenizer st = new StringTokenizer(buffer);
                if (st.hasMoreTokens()) {
                    label = st.nextToken();
                    Trace.trace("XMDADEVF", "CdDvd.readLabelFile(): label = " + label);
                    if (label.equals("32+0")) {
                        label = null;
                    }
                }
            } else {
                Trace.trace("XMDADEVF", "CdDvd.readLabelFile(): The label file was created with the chkudf command");
                if (buffer.indexOf("(M) Volume Identifier:") != -1) {
                    String subBuffer = buffer.substring(26, buffer.length() - 1);
                    if (subBuffer.startsWith("0 - ")) {
                        label = buffer.substring(30, buffer.length() - 1);
                        Trace.trace("XMDADEVF", "CdDvd.readLabelFile(): label = " + label);
                    } else {
                        label = subBuffer;
                        Trace.trace("XMDADEVF", "CdDvd.readLabelFile(): label = " + label);
                    }
                } else {
                    label = null;
                    Trace.trace("XMDADEVF", "CdDvd.readLabelFile(): There is no label present");
                }
            }
        }
        tfr.close();
        Trace.trace("XMDADEVT", "<- CdDvd.readLabelFile()");
        return label;
    }

    public void lockDriveDoor() throws MediaDeviceException, MediaDeviceLockException, UnsupportedOperationException {
        Trace.trace("XMDADEVT", "-> CdDvd.lockDriveDoor()");
        if (!this.isLockValid()) {
            throw new MediaDeviceLockException("Operation attempted by task other than device lock owner");
        }
        this.doorLockControl("media.device.lockdoor");
        this.driveDoorLocked = true;
        Trace.trace("XMDADEVT", "<- CdDvd.lockDriveDoor()");
    }

    public void unLockDriveDoor() throws MediaDeviceException, MediaDeviceLockException, UnsupportedOperationException {
        Trace.trace("XMDADEVT", "-> CdDvd.unLockDriveDoor()");
        if (!this.isLockValid()) {
            throw new MediaDeviceLockException("Operation attempted by task other than device lock owner");
        }
        this.doorLockControl("media.device.unlockdoor");
        this.driveDoorLocked = false;
        Trace.trace("XMDADEVT", "<- CdDvd.unLockDriveDoor()");
    }

    private void doorLockControl(String Command) throws MediaDeviceException {
        Trace.trace("XMDADEVT", "-> CdDvd.doorLockControl(Command = " + Command + ")");
        try {
            String[] lockCmd = new String[]{this.mediaServicesParameters.getParm("media.device.lock.script"), this.mediaServicesParameters.getParm(Command), this.mediaDeviceProperties.getDeviceFile(), this.mediaServicesParameters.getParm("media.log.dir") + this.mediaServicesParameters.getParm("media.log")};
            Trace.trace("XMDADEVF", "CdDvd.doorLockControl(): lockCmd[0] = " + lockCmd[0]);
            Trace.trace("XMDADEVF", "CdDvd.doorLockControl(): lockCmd[1] = " + lockCmd[1]);
            Trace.trace("XMDADEVF", "CdDvd.doorLockControl(): lockCmd[2] = " + lockCmd[2]);
            Trace.trace("XMDADEVF", "CdDvd.doorLockControl(): lockCmd[3] = " + lockCmd[3]);
            int rc = RootProcess.executeProgram(lockCmd);
            Trace.trace("XMDADEVF", "CdDvd.doorLockControl(): rc = " + rc);
            if (rc != 0) {
                throw new IOException("failure to (un)lock media");
            }
        }
        catch (Exception exc) {
            Trace.trace("XMDADEVF", exc);
            MediaDeviceException mdexc = new MediaDeviceException(exc);
            new FrameworkLog(MediaServicesErrorIds._logInfo, 627, mdexc).log();
            throw mdexc;
        }
        Trace.trace("XMDADEVT", "<- CdDvd.doorLockControl()");
    }

    public void format(String label, int fileSystemType) throws MediaDeviceException, MediaDeviceLockException, NoMediaPresentException, IllegalArgumentException, UnsupportedOperationException {
        Trace.trace("XMDADEVT", "-> CdDvd.format(label = " + label + ", " + "fileSystemType = " + fileSystemType + ")");
        if (!this.isLockValid()) {
            throw new MediaDeviceLockException("Operation attempted by task other than device lock owner", this.mediaDeviceIdentifier.getCurrentLockOwner());
        }
        if (fileSystemType != 2) {
            throw new IllegalArgumentException("Invalid filesystem type specified to format DVD-RAM");
        }
        if (!this.isFormattable()) {
            throw new UnsupportedOperationException("The media device does not support formatting");
        }
        if (!this.isMediaPresent()) {
            throw new NoMediaPresentException("missing media");
        }
        try {
            String[] formatCmd = new String[]{this.mediaServicesParameters.getParm("media.dvdformat.script"), this.mediaDeviceProperties.getDeviceFile(), this.mediaServicesParameters.getParm("media.log.dir") + this.mediaServicesParameters.getParm("media.log"), label};
            Trace.trace("XMDADEVF", "CdDvd.format(): formatCmd[0] = " + formatCmd[0]);
            Trace.trace("XMDADEVF", "CdDvd.format(): formatCmd[1] = " + formatCmd[1]);
            Trace.trace("XMDADEVF", "CdDvd.format(): formatCmd[2] = " + formatCmd[2]);
            Trace.trace("XMDADEVF", "CdDvd.format(): formatCmd[3] = " + formatCmd[3]);
            int rc = RootProcess.executeProgram(formatCmd);
            Trace.trace("XMDADEVF", "CdDvd.format(): rc = " + rc);
            if (rc != 0) {
                throw new IOException("failure to format DVD");
            }
        }
        catch (Exception exc) {
            Trace.trace("XMDADEVF", exc);
            MediaDeviceException mdexc = new MediaDeviceException(exc);
            new FrameworkLog(MediaServicesErrorIds._logInfo, 628, mdexc).log();
            throw mdexc;
        }
        Trace.trace("XMDADEVT", "<- CdDvd.format()");
    }
}

